;====================================================
;
;	Api92/Api89 Example Source Code
;
;	(c) NeXO Software, Ibrahim - Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;	web : http://perso.wanadoo.fr/scherrer/ben/
;
;	File>	exceptio.asm
;	> This example shows how you can use
;	easly interuptions or exceptions with
;	the Api92/Api89 library
;====================================================


;--------------------- Includes ---------------------

	include "tios.h"
	include	"api92.h"
	include "api92cst.h"


;#ifdef TIPLUS
;#ifdef TI89
	xdef	_ti89
;#else
	xdef	_ti92plus
;#endif
;#endif

;------------ Start of assembly program -------------

	xdef	_main
	xdef	_comment

_main:
	jsr	api92::ClearScreen
	move.w	#20,counter

	move.l	#INT1_VECTOR,a0			;Set new timer routine address
	lea	timer_routine(PC),a1
	jsr	api92::SetIntVector
	move.l	a1,save_old_vect


	clr.w	d0				;Set small font
	jsr	api92::SetFont
	lea	title(PC),a0			;Draw string
	jsr	api92::draw_sString

	jsr	api92::WaitKey

	move.l	#INT1_VECTOR,a0			;Restore old timer routine
	move.l	save_old_vect(PC),a1
	jsr	api92::SetIntVector

	rts


timer_routine:
	subq.w	#1,counter
	bne.s	\skip

	move.w	#10,counter

	move.l	#LCD_MEM,a0
	adda.w	#30+6,a0

	moveq.w #12,d0			;13 lines
\invert	not.l	(a0)			;invert
	lea	30(a0),a0
	dbra.s	d0,\invert

\skip	move.l	save_old_vect(PC),-(a7)		;call old timer routine
	rts


;------------------- Program Data -------------------

save_old_vect:	dc.l	0
counter		dc.w	0

title		dc.b	5,5,"It is very simple to use exceptions !",0

_comment	dc.b	"Example of exeption Handler",0


;-------------------- End of program ------------------

	end


